/** !------------------------------------------------------------------------->
*
*  @file Rte_generated.c
*
*  @creationDate 12 February 2025 14:57:23
*
*  @brief Generated Rte configuration source file.
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2025, dSPACE GmbH. All rights reserved.
*
*  @version
*
*   <hr><br>
*!-------------------------------------------------------------------------->*/

#include "Rte_generated.h"
#include <string.h>
#include <float.h>
#include <limits.h>
#include "StateManager_generated.h"
#include "ScalingFunctions.h"


#define Rte_TX_Inst_0_Torque_Compressor_10834_10561_10897_phys (bus_Configuration_1_Torque_Compressor_Value_IO_Signal = (bus_Configuration_1_Torque_Compressor_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_Torque_Compressor_Value_MDL_SignalNoCast \
    : bus_Configuration_1_Torque_Compressor_Value_TA_Replacevalue))
float64 Rte_TX_Inst_0_Torque_Compressor_10834_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_Torque_Compressor_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_Torque_Compressor_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_Torque_Compressor_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_Torque_Compressor_Value_TA_Switchvalue;;

#define Rte_TX_Inst_0_EPower_Compressor_10835_10561_10897_phys (bus_Configuration_1_EPower_Compressor_Value_IO_Signal = (bus_Configuration_1_EPower_Compressor_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_EPower_Compressor_Value_MDL_SignalNoCast \
    : bus_Configuration_1_EPower_Compressor_Value_TA_Replacevalue))
float64 Rte_TX_Inst_0_EPower_Compressor_10835_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_EPower_Compressor_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_EPower_Compressor_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_EPower_Compressor_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_EPower_Compressor_Value_TA_Switchvalue;;

#define Rte_TX_Inst_0_AngVel_Compressor_10836_10561_10897_phys (bus_Configuration_1_AngVel_Compressor_Value_IO_Signal = (bus_Configuration_1_AngVel_Compressor_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_AngVel_Compressor_Value_MDL_SignalNoCast \
    : bus_Configuration_1_AngVel_Compressor_Value_TA_Replacevalue))
float64 Rte_TX_Inst_0_AngVel_Compressor_10836_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_AngVel_Compressor_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_AngVel_Compressor_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_AngVel_Compressor_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_AngVel_Compressor_Value_TA_Switchvalue;;

#define Rte_TX_Inst_4_T_battery4_10816_10561_10897_phys (bus_Configuration_1_T_battery4_Value_IO_Signal = (bus_Configuration_1_T_battery4_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_T_battery4_Value_MDL_SignalNoCast \
    : bus_Configuration_1_T_battery4_Value_TA_Replacevalue))
float64 Rte_TX_Inst_4_T_battery4_10816_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_battery4_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_battery4_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_battery4_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_T_battery4_Value_TA_Switchvalue;;

#define Rte_TX_Inst_4_T_battery3_10817_10561_10897_phys (bus_Configuration_1_T_battery3_Value_IO_Signal = (bus_Configuration_1_T_battery3_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_T_battery3_Value_MDL_SignalNoCast \
    : bus_Configuration_1_T_battery3_Value_TA_Replacevalue))
float64 Rte_TX_Inst_4_T_battery3_10817_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_battery3_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_battery3_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_battery3_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_T_battery3_Value_TA_Switchvalue;;

#define Rte_TX_Inst_4_T_battery2_10818_10561_10897_phys (bus_Configuration_1_T_battery2_Value_IO_Signal = (bus_Configuration_1_T_battery2_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_T_battery2_Value_MDL_SignalNoCast \
    : bus_Configuration_1_T_battery2_Value_TA_Replacevalue))
float64 Rte_TX_Inst_4_T_battery2_10818_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_battery2_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_battery2_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_battery2_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_T_battery2_Value_TA_Switchvalue;;

#define Rte_TX_Inst_4_T_battery1_10819_10561_10897_phys (bus_Configuration_1_T_battery1_Value_IO_Signal = (bus_Configuration_1_T_battery1_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_T_battery1_Value_MDL_SignalNoCast \
    : bus_Configuration_1_T_battery1_Value_TA_Replacevalue))
float64 Rte_TX_Inst_4_T_battery1_10819_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_battery1_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_battery1_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_battery1_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_T_battery1_Value_TA_Switchvalue;;

#define Rte_TX_Inst_5_T_motor_10812_10561_10897_phys (bus_Configuration_1_T_motor_Value_IO_Signal = (bus_Configuration_1_T_motor_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_T_motor_Value_MDL_SignalNoCast \
    : bus_Configuration_1_T_motor_Value_TA_Replacevalue))
float64 Rte_TX_Inst_5_T_motor_10812_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_motor_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_motor_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_motor_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_T_motor_Value_TA_Switchvalue;;

#define Rte_TX_Inst_5_T_inverter_10813_10561_10897_phys (bus_Configuration_1_T_inverter_Value_IO_Signal = (bus_Configuration_1_T_inverter_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_T_inverter_Value_MDL_SignalNoCast \
    : bus_Configuration_1_T_inverter_Value_TA_Replacevalue))
float64 Rte_TX_Inst_5_T_inverter_10813_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_inverter_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_inverter_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_inverter_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_T_inverter_Value_TA_Switchvalue;;

#define Rte_TX_Inst_5_T_coolant_inverter_out_10814_10561_10897_phys (bus_Configuration_1_T_coolant_inverter_out_Value_IO_Signal = (bus_Configuration_1_T_coolant_inverter_out_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_T_coolant_inverter_out_Value_MDL_SignalNoCast \
    : bus_Configuration_1_T_coolant_inverter_out_Value_TA_Replacevalue))
float64 Rte_TX_Inst_5_T_coolant_inverter_out_10814_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_coolant_inverter_out_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_coolant_inverter_out_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_coolant_inverter_out_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_T_coolant_inverter_out_Value_TA_Switchvalue;;

#define Rte_TX_Inst_5_T_coolant_battery_in_10815_10561_10897_phys (bus_Configuration_1_T_coolant_battery_in_Value_IO_Signal = (bus_Configuration_1_T_coolant_battery_in_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_T_coolant_battery_in_Value_MDL_SignalNoCast \
    : bus_Configuration_1_T_coolant_battery_in_Value_TA_Replacevalue))
float64 Rte_TX_Inst_5_T_coolant_battery_in_10815_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_coolant_battery_in_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_coolant_battery_in_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_T_coolant_battery_in_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_T_coolant_battery_in_Value_TA_Switchvalue;;

#define Rte_TX_Inst_6_PJoule_battery_10808_10561_10897_phys (bus_Configuration_1_PJoule_battery_Value_IO_Signal = (bus_Configuration_1_PJoule_battery_Value_TA_Switchvalue == 0 \
    ? (uint16)bus_Configuration_1_PJoule_battery_Value_MDL_SignalNoCast \
    : bus_Configuration_1_PJoule_battery_Value_TA_Replacevalue))
uint16 Rte_TX_Inst_6_PJoule_battery_10808_10561_10897_phys_last;
EXTERN_C_DECL volatile uint16 bus_Configuration_1_PJoule_battery_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_PJoule_battery_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile uint16 bus_Configuration_1_PJoule_battery_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_PJoule_battery_Value_TA_Switchvalue;;

#define Rte_TX_Inst_6_p_cond_10809_10561_10897_phys (bus_Configuration_1_p_cond_Value_IO_Signal = (bus_Configuration_1_p_cond_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_p_cond_Value_MDL_SignalNoCast \
    : bus_Configuration_1_p_cond_Value_TA_Replacevalue))
float64 Rte_TX_Inst_6_p_cond_10809_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_p_cond_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_p_cond_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_p_cond_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_p_cond_Value_TA_Switchvalue;;

#define Rte_TX_Inst_6_p_chiller_10810_10561_10897_phys (bus_Configuration_1_p_chiller_Value_IO_Signal = (bus_Configuration_1_p_chiller_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_p_chiller_Value_MDL_SignalNoCast \
    : bus_Configuration_1_p_chiller_Value_TA_Replacevalue))
float64 Rte_TX_Inst_6_p_chiller_10810_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_p_chiller_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_p_chiller_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_p_chiller_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_p_chiller_Value_TA_Switchvalue;;

#define Rte_TX_Inst_6_i_battery_10811_10561_10897_phys (bus_Configuration_1_i_battery_Value_IO_Signal = (bus_Configuration_1_i_battery_Value_TA_Switchvalue == 0 \
    ? (float64)bus_Configuration_1_i_battery_Value_MDL_SignalNoCast \
    : bus_Configuration_1_i_battery_Value_TA_Replacevalue))
float64 Rte_TX_Inst_6_i_battery_10811_10561_10897_phys_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_i_battery_Value_TA_Replacevalue;
EXTERN_C_DECL volatile float64 bus_Configuration_1_i_battery_Value_MDL_SignalNoCast;
EXTERN_C_DECL volatile float64 bus_Configuration_1_i_battery_Value_IO_Signal;
EXTERN_C_DECL volatile uint8 bus_Configuration_1_i_battery_Value_TA_Switchvalue;;


#define Rte_RX_Inst_1_cmd_rad_bypass_10826_10561_10897_phys bus_Configuration_1_cmd_rad_bypass_Value_IO_Signal
static uint8 Rte_RX_Inst_1_cmd_rad_bypass_10826_10561_10897_coded_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_cmd_rad_bypass_Value_IO_Signal;

#define Rte_RX_Inst_1_cmd_parallel_serial_10827_10561_10897_phys bus_Configuration_1_cmd_parallel_serial_Value_IO_Signal
static uint8 Rte_RX_Inst_1_cmd_parallel_serial_10827_10561_10897_coded_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_cmd_parallel_serial_Value_IO_Signal;

#define Rte_RX_Inst_1_cmd_motor_pump_10828_10561_10897_phys bus_Configuration_1_cmd_motor_pump_Value_IO_Signal
static uint8 Rte_RX_Inst_1_cmd_motor_pump_10828_10561_10897_coded_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_cmd_motor_pump_Value_IO_Signal;

#define Rte_RX_Inst_1_cmd_heater_10829_10561_10897_phys bus_Configuration_1_cmd_heater_Value_IO_Signal
static uint8 Rte_RX_Inst_1_cmd_heater_10829_10561_10897_coded_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_cmd_heater_Value_IO_Signal;

#define Rte_RX_Inst_1_cmd_fan_10830_10561_10897_phys bus_Configuration_1_cmd_fan_Value_IO_Signal
static uint8 Rte_RX_Inst_1_cmd_fan_10830_10561_10897_coded_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_cmd_fan_Value_IO_Signal;

#define Rte_RX_Inst_1_cmd_comp_10831_10561_10897_phys bus_Configuration_1_cmd_comp_Value_IO_Signal
static uint16 Rte_RX_Inst_1_cmd_comp_10831_10561_10897_coded_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_cmd_comp_Value_IO_Signal;

#define Rte_RX_Inst_1_cmd_chiller_bypass_10832_10561_10897_phys bus_Configuration_1_cmd_chiller_bypass_Value_IO_Signal
static uint8 Rte_RX_Inst_1_cmd_chiller_bypass_10832_10561_10897_coded_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_cmd_chiller_bypass_Value_IO_Signal;

#define Rte_RX_Inst_1_cmd_battery_pump_10833_10561_10897_phys bus_Configuration_1_cmd_battery_pump_Value_IO_Signal
static uint8 Rte_RX_Inst_1_cmd_battery_pump_10833_10561_10897_coded_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_cmd_battery_pump_Value_IO_Signal;

#define Rte_RX_Inst_2_Q_motor_10822_10561_10897_phys bus_Configuration_1_Q_motor_Value_IO_Signal
static uint16 Rte_RX_Inst_2_Q_motor_10822_10561_10897_coded_last;
EXTERN_C_DECL volatile uint16 bus_Configuration_1_Q_motor_Value_IO_Signal;

#define Rte_RX_Inst_2_Q_inverter_10823_10561_10897_phys bus_Configuration_1_Q_inverter_Value_IO_Signal
static uint16 Rte_RX_Inst_2_Q_inverter_10823_10561_10897_coded_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_Q_inverter_Value_IO_Signal;

#define Rte_RX_Inst_2_Q_dcdc_10824_10561_10897_phys bus_Configuration_1_Q_dcdc_Value_IO_Signal
static uint16 Rte_RX_Inst_2_Q_dcdc_10824_10561_10897_coded_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_Q_dcdc_Value_IO_Signal;

#define Rte_RX_Inst_2_Q_charger_10825_10561_10897_phys bus_Configuration_1_Q_charger_Value_IO_Signal
static uint16 Rte_RX_Inst_2_Q_charger_10825_10561_10897_coded_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_Q_charger_Value_IO_Signal;

#define Rte_RX_Inst_3_v_vehicle_10820_10561_10897_phys bus_Configuration_1_v_vehicle_Value_IO_Signal
static uint16 Rte_RX_Inst_3_v_vehicle_10820_10561_10897_coded_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_v_vehicle_Value_IO_Signal;

#define Rte_RX_Inst_3_I_traction_10821_10561_10897_phys bus_Configuration_1_I_traction_Value_IO_Signal
static sint16 Rte_RX_Inst_3_I_traction_10821_10561_10897_coded_last;
EXTERN_C_DECL volatile float64 bus_Configuration_1_I_traction_Value_IO_Signal;


/**************************************************************************************************\
 *** FUNCTION:
 ***    Rte_COMCbk_RxPDU
 *** 
 *** DESCRIPTION:
 ***     Callback for the COM Module to indicate the reception of a PDU.
 ***     This is a non AUTOSAR standard callback function and is used to optimize the
 ***     trace access to physical signal values. Using the callback the scaling algorithm 
 ***     only needs to be executed whenever a new signal value is received, removing the necessity to
 ***     poll COM signal values for trace access.
 *** 
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     PduIdType       ComRxPduId       ID of the received pdu.
 ***                                     
 *** 
 *** RETURNS:
 ***     uint8    The status code of the function call.
\**************************************************************************************************/
static UNUSED void Rte_COMCbk_RxPDU(PduIdType ComRxPduId)
{
    INTENDED_UNREFERENCED_PARAMETER(ComRxPduId);
}

/*------------------------------------------------------------------------------------------------*\
  FUNCTION PROTOTYPES
\*------------------------------------------------------------------------------------------------*/

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_VariableInitialize
 *** 
 *** DESCRIPTION:
 ***    This function is called before the application starts and may be used to extend the
 ***    initialization phase. Depending on InitialValueUsage parameter, it is called either in OnInit
 ***    or OnStart application phase.
 *** PARAMETERS:
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
void Rte_VariableInitialize(void)
{
    /* Initialization of the TX signals and triggers */
    /* Signal: Inst_0_Torque_Compressor */
    bus_Configuration_1_Torque_Compressor_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_Torque_Compressor_Value_TA_Switchvalue = 0;
    bus_Configuration_1_Torque_Compressor_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_0_Torque_Compressor_10834_10561_10897, TRUE);
    /* Signal: Inst_0_EPower_Compressor */
    bus_Configuration_1_EPower_Compressor_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_EPower_Compressor_Value_TA_Switchvalue = 0;
    bus_Configuration_1_EPower_Compressor_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_0_EPower_Compressor_10835_10561_10897, TRUE);
    /* Signal: Inst_0_AngVel_Compressor */
    bus_Configuration_1_AngVel_Compressor_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_AngVel_Compressor_Value_TA_Switchvalue = 0;
    bus_Configuration_1_AngVel_Compressor_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_0_AngVel_Compressor_10836_10561_10897, TRUE);
    /* Signal: Inst_4_T_battery4 */
    bus_Configuration_1_T_battery4_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_T_battery4_Value_TA_Switchvalue = 0;
    bus_Configuration_1_T_battery4_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_4_T_battery4_10816_10561_10897, TRUE);
    /* Signal: Inst_4_T_battery3 */
    bus_Configuration_1_T_battery3_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_T_battery3_Value_TA_Switchvalue = 0;
    bus_Configuration_1_T_battery3_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_4_T_battery3_10817_10561_10897, TRUE);
    /* Signal: Inst_4_T_battery2 */
    bus_Configuration_1_T_battery2_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_T_battery2_Value_TA_Switchvalue = 0;
    bus_Configuration_1_T_battery2_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_4_T_battery2_10818_10561_10897, TRUE);
    /* Signal: Inst_4_T_battery1 */
    bus_Configuration_1_T_battery1_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_T_battery1_Value_TA_Switchvalue = 0;
    bus_Configuration_1_T_battery1_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_4_T_battery1_10819_10561_10897, TRUE);
    /* Signal: Inst_5_T_motor */
    bus_Configuration_1_T_motor_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_T_motor_Value_TA_Switchvalue = 0;
    bus_Configuration_1_T_motor_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_5_T_motor_10812_10561_10897, TRUE);
    /* Signal: Inst_5_T_inverter */
    bus_Configuration_1_T_inverter_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_T_inverter_Value_TA_Switchvalue = 0;
    bus_Configuration_1_T_inverter_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_5_T_inverter_10813_10561_10897, TRUE);
    /* Signal: Inst_5_T_coolant_inverter_out */
    bus_Configuration_1_T_coolant_inverter_out_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_T_coolant_inverter_out_Value_TA_Switchvalue = 0;
    bus_Configuration_1_T_coolant_inverter_out_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_5_T_coolant_inverter_out_10814_10561_10897, TRUE);
    /* Signal: Inst_5_T_coolant_battery_in */
    bus_Configuration_1_T_coolant_battery_in_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_T_coolant_battery_in_Value_TA_Switchvalue = 0;
    bus_Configuration_1_T_coolant_battery_in_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_5_T_coolant_battery_in_10815_10561_10897, TRUE);
    /* Signal: Inst_6_PJoule_battery */
    bus_Configuration_1_PJoule_battery_Value_TA_Replacevalue = (uint16)0;
    bus_Configuration_1_PJoule_battery_Value_TA_Switchvalue = 0;
    bus_Configuration_1_PJoule_battery_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_6_PJoule_battery_10808_10561_10897, TRUE);
    /* Signal: Inst_6_p_cond */
    bus_Configuration_1_p_cond_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_p_cond_Value_TA_Switchvalue = 0;
    bus_Configuration_1_p_cond_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_6_p_cond_10809_10561_10897, TRUE);
    /* Signal: Inst_6_p_chiller */
    bus_Configuration_1_p_chiller_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_p_chiller_Value_TA_Switchvalue = 0;
    bus_Configuration_1_p_chiller_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_6_p_chiller_10810_10561_10897, TRUE);
    /* Signal: Inst_6_i_battery */
    bus_Configuration_1_i_battery_Value_TA_Replacevalue = (float64)0.0;
    bus_Configuration_1_i_battery_Value_TA_Switchvalue = 0;
    bus_Configuration_1_i_battery_Value_MDL_SignalNoCast = (float64)0.0;
    
    Rte_SetCodedValue(Rte_X_Inst_6_i_battery_10811_10561_10897, TRUE);

    /* Initialization of the RX signals and triggers */
    /* Signal: Inst_1_cmd_rad_bypass */
    Com_RX_Inst_1_cmd_rad_bypass_10826_10561_10897_sgn_val = (uint8)0;
    Rte_SetPhysicalValue(Rte_X_Inst_1_cmd_rad_bypass_10826_10561_10897, TRUE);
    /* Signal: Inst_1_cmd_parallel_serial */
    Com_RX_Inst_1_cmd_parallel_serial_10827_10561_10897_sgn_val = (uint8)0;
    Rte_SetPhysicalValue(Rte_X_Inst_1_cmd_parallel_serial_10827_10561_10897, TRUE);
    /* Signal: Inst_1_cmd_motor_pump */
    Com_RX_Inst_1_cmd_motor_pump_10828_10561_10897_sgn_val = (uint8)0;
    Rte_SetPhysicalValue(Rte_X_Inst_1_cmd_motor_pump_10828_10561_10897, TRUE);
    /* Signal: Inst_1_cmd_heater */
    Com_RX_Inst_1_cmd_heater_10829_10561_10897_sgn_val = (uint8)0;
    Rte_SetPhysicalValue(Rte_X_Inst_1_cmd_heater_10829_10561_10897, TRUE);
    /* Signal: Inst_1_cmd_fan */
    Com_RX_Inst_1_cmd_fan_10830_10561_10897_sgn_val = (uint8)0;
    Rte_SetPhysicalValue(Rte_X_Inst_1_cmd_fan_10830_10561_10897, TRUE);
    /* Signal: Inst_1_cmd_comp */
    Com_RX_Inst_1_cmd_comp_10831_10561_10897_sgn_val = (uint16)0;
    Rte_SetPhysicalValue(Rte_X_Inst_1_cmd_comp_10831_10561_10897, TRUE);
    /* Signal: Inst_1_cmd_chiller_bypass */
    Com_RX_Inst_1_cmd_chiller_bypass_10832_10561_10897_sgn_val = (uint8)0;
    Rte_SetPhysicalValue(Rte_X_Inst_1_cmd_chiller_bypass_10832_10561_10897, TRUE);
    /* Signal: Inst_1_cmd_battery_pump */
    Com_RX_Inst_1_cmd_battery_pump_10833_10561_10897_sgn_val = (uint8)0;
    Rte_SetPhysicalValue(Rte_X_Inst_1_cmd_battery_pump_10833_10561_10897, TRUE);
    /* Signal: Inst_2_Q_motor */
    Com_RX_Inst_2_Q_motor_10822_10561_10897_sgn_val = (uint16)0;
    Rte_SetPhysicalValue(Rte_X_Inst_2_Q_motor_10822_10561_10897, TRUE);
    /* Signal: Inst_2_Q_inverter */
    Com_RX_Inst_2_Q_inverter_10823_10561_10897_sgn_val = (uint16)0;
    Rte_SetPhysicalValue(Rte_X_Inst_2_Q_inverter_10823_10561_10897, TRUE);
    /* Signal: Inst_2_Q_dcdc */
    Com_RX_Inst_2_Q_dcdc_10824_10561_10897_sgn_val = (uint16)0;
    Rte_SetPhysicalValue(Rte_X_Inst_2_Q_dcdc_10824_10561_10897, TRUE);
    /* Signal: Inst_2_Q_charger */
    Com_RX_Inst_2_Q_charger_10825_10561_10897_sgn_val = (uint16)0;
    Rte_SetPhysicalValue(Rte_X_Inst_2_Q_charger_10825_10561_10897, TRUE);
    /* Signal: Inst_3_v_vehicle */
    Com_RX_Inst_3_v_vehicle_10820_10561_10897_sgn_val = (uint16)0;
    Rte_SetPhysicalValue(Rte_X_Inst_3_v_vehicle_10820_10561_10897, TRUE);
    /* Signal: Inst_3_I_traction */
    Com_RX_Inst_3_I_traction_10821_10561_10897_sgn_val = (sint16)0/*0x0*/;
    Rte_SetPhysicalValue(Rte_X_Inst_3_I_traction_10821_10561_10897, TRUE);

}

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_SetPhysicalValue
 *** 
 *** DESCRIPTION:
 ***     Calculates a new physical value, if the coded value has changed.
 *** 
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be sent.
 ***     boolean           always         Flag which enforces calculation even if the coded signal did not change.
 ***                                      This behavior is used for initialization during startup
 *** 
\**************************************************************************************************/
void Rte_SetPhysicalValue(Rte_SignalIdType SignalId, boolean always)
{
    POSSIBLE_UNREFERENCED_PARAMETER(SignalId);
    POSSIBLE_UNREFERENCED_PARAMETER(always);
    switch (SignalId) {
        case Rte_X_Inst_1_cmd_rad_bypass_10826_10561_10897 : {
            uint8 tempVar = Com_RX_Inst_1_cmd_rad_bypass_10826_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_1_cmd_rad_bypass_10826_10561_10897_coded_last || always) {
            *((float64*)(&Rte_RX_Inst_1_cmd_rad_bypass_10826_10561_10897_phys)) = (float64)Scale_Linear_From_uint8_noround(&tempVar, 0, 0.1, 1);
            Rte_RX_Inst_1_cmd_rad_bypass_10826_10561_10897_coded_last = tempVar;
            }
         }
         break;
        case Rte_X_Inst_1_cmd_parallel_serial_10827_10561_10897 : {
            uint8 tempVar = Com_RX_Inst_1_cmd_parallel_serial_10827_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_1_cmd_parallel_serial_10827_10561_10897_coded_last || always) {
            *((float64*)(&Rte_RX_Inst_1_cmd_parallel_serial_10827_10561_10897_phys)) = (float64)Scale_Linear_From_uint8_noround(&tempVar, 0, 0.1, 1);
            Rte_RX_Inst_1_cmd_parallel_serial_10827_10561_10897_coded_last = tempVar;
            }
         }
         break;
        case Rte_X_Inst_1_cmd_motor_pump_10828_10561_10897 : {
            uint8 tempVar = Com_RX_Inst_1_cmd_motor_pump_10828_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_1_cmd_motor_pump_10828_10561_10897_coded_last || always) {
            *((float64*)(&Rte_RX_Inst_1_cmd_motor_pump_10828_10561_10897_phys)) = (float64)Scale_Linear_From_uint8_noround(&tempVar, 0, 0.1, 1);
            Rte_RX_Inst_1_cmd_motor_pump_10828_10561_10897_coded_last = tempVar;
            }
         }
         break;
        case Rte_X_Inst_1_cmd_heater_10829_10561_10897 : {
            uint8 tempVar = Com_RX_Inst_1_cmd_heater_10829_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_1_cmd_heater_10829_10561_10897_coded_last || always) {
            *((float64*)(&Rte_RX_Inst_1_cmd_heater_10829_10561_10897_phys)) = (float64)Scale_Linear_From_uint8_noround(&tempVar, 0, 0.1, 1);
            Rte_RX_Inst_1_cmd_heater_10829_10561_10897_coded_last = tempVar;
            }
         }
         break;
        case Rte_X_Inst_1_cmd_fan_10830_10561_10897 : {
            uint8 tempVar = Com_RX_Inst_1_cmd_fan_10830_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_1_cmd_fan_10830_10561_10897_coded_last || always) {
            *((float64*)(&Rte_RX_Inst_1_cmd_fan_10830_10561_10897_phys)) = (float64)Scale_Linear_From_uint8_noround(&tempVar, 0, 0.1, 1);
            Rte_RX_Inst_1_cmd_fan_10830_10561_10897_coded_last = tempVar;
            }
         }
         break;
        case Rte_X_Inst_1_cmd_comp_10831_10561_10897 : {
            uint16 tempVar = Com_RX_Inst_1_cmd_comp_10831_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_1_cmd_comp_10831_10561_10897_coded_last || always) {
            *((float64*)(&Rte_RX_Inst_1_cmd_comp_10831_10561_10897_phys)) = (float64)Scale_Linear_From_uint16_noround(&tempVar, 0, 0.1, 1);
            Rte_RX_Inst_1_cmd_comp_10831_10561_10897_coded_last = tempVar;
            }
         }
         break;
        case Rte_X_Inst_1_cmd_chiller_bypass_10832_10561_10897 : {
            uint8 tempVar = Com_RX_Inst_1_cmd_chiller_bypass_10832_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_1_cmd_chiller_bypass_10832_10561_10897_coded_last || always) {
            *((float64*)(&Rte_RX_Inst_1_cmd_chiller_bypass_10832_10561_10897_phys)) = (float64)Scale_Linear_From_uint8_noround(&tempVar, 0, 0.1, 1);
            Rte_RX_Inst_1_cmd_chiller_bypass_10832_10561_10897_coded_last = tempVar;
            }
         }
         break;
        case Rte_X_Inst_1_cmd_battery_pump_10833_10561_10897 : {
            uint8 tempVar = Com_RX_Inst_1_cmd_battery_pump_10833_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_1_cmd_battery_pump_10833_10561_10897_coded_last || always) {
            *((float64*)(&Rte_RX_Inst_1_cmd_battery_pump_10833_10561_10897_phys)) = (float64)Scale_Linear_From_uint8_noround(&tempVar, 0, 0.1, 1);
            Rte_RX_Inst_1_cmd_battery_pump_10833_10561_10897_coded_last = tempVar;
            }
         }
         break;
        case Rte_X_Inst_2_Q_motor_10822_10561_10897 : {
            uint16 tempVar = Com_RX_Inst_2_Q_motor_10822_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_2_Q_motor_10822_10561_10897_coded_last || always) {
            *((uint16*)(&Rte_RX_Inst_2_Q_motor_10822_10561_10897_phys)) = (uint16)*((uint16*)&tempVar);
            Rte_RX_Inst_2_Q_motor_10822_10561_10897_coded_last = tempVar;
            }
         }
         break;
        case Rte_X_Inst_2_Q_inverter_10823_10561_10897 : {
            uint16 tempVar = Com_RX_Inst_2_Q_inverter_10823_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_2_Q_inverter_10823_10561_10897_coded_last || always) {
            *((float64*)(&Rte_RX_Inst_2_Q_inverter_10823_10561_10897_phys)) = (float64)Scale_Linear_From_uint16_noround(&tempVar, 0, 0.1, 1);
            Rte_RX_Inst_2_Q_inverter_10823_10561_10897_coded_last = tempVar;
            }
         }
         break;
        case Rte_X_Inst_2_Q_dcdc_10824_10561_10897 : {
            uint16 tempVar = Com_RX_Inst_2_Q_dcdc_10824_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_2_Q_dcdc_10824_10561_10897_coded_last || always) {
            *((float64*)(&Rte_RX_Inst_2_Q_dcdc_10824_10561_10897_phys)) = (float64)Scale_Linear_From_uint16_noround(&tempVar, 0, 0.1, 1);
            Rte_RX_Inst_2_Q_dcdc_10824_10561_10897_coded_last = tempVar;
            }
         }
         break;
        case Rte_X_Inst_2_Q_charger_10825_10561_10897 : {
            uint16 tempVar = Com_RX_Inst_2_Q_charger_10825_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_2_Q_charger_10825_10561_10897_coded_last || always) {
            *((float64*)(&Rte_RX_Inst_2_Q_charger_10825_10561_10897_phys)) = (float64)Scale_Linear_From_uint16_noround(&tempVar, 0, 0.1, 1);
            Rte_RX_Inst_2_Q_charger_10825_10561_10897_coded_last = tempVar;
            }
         }
         break;
        case Rte_X_Inst_3_v_vehicle_10820_10561_10897 : {
            uint16 tempVar = Com_RX_Inst_3_v_vehicle_10820_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_3_v_vehicle_10820_10561_10897_coded_last || always) {
            *((float64*)(&Rte_RX_Inst_3_v_vehicle_10820_10561_10897_phys)) = (float64)Scale_Linear_From_uint16_noround(&tempVar, 0, 0.1, 1);
            Rte_RX_Inst_3_v_vehicle_10820_10561_10897_coded_last = tempVar;
            }
         }
         break;
        case Rte_X_Inst_3_I_traction_10821_10561_10897 : {
            sint16 tempVar = Com_RX_Inst_3_I_traction_10821_10561_10897_sgn_val;
            if (tempVar != Rte_RX_Inst_3_I_traction_10821_10561_10897_coded_last || always) {
            *((float64*)(&Rte_RX_Inst_3_I_traction_10821_10561_10897_phys)) = (float64)Scale_Linear_From_sint16_noround(&tempVar, 0, 0.1, 1);
            Rte_RX_Inst_3_I_traction_10821_10561_10897_coded_last = tempVar;
            }
         }
         break;
    }

}

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_SetCodedValue
 *** 
 *** DESCRIPTION:
 ***     Calculates a new coded value, if the physical value has changed.
 *** 
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be sent.
 ***     boolean           always         Flag which enforces calculation even if the physical signal did not change.
 *** 
 *** RETURNS:
 ***     boolean  Flag which inidcates that a calculation was performed and the underlying 
 ***              PDU has to be updated.
 \**************************************************************************************************/
boolean Rte_SetCodedValue(Rte_SignalIdType SignalId, boolean always)
{
    POSSIBLE_UNREFERENCED_PARAMETER(SignalId);
    POSSIBLE_UNREFERENCED_PARAMETER(always);
    switch (SignalId) {
        case Rte_X_Inst_0_Torque_Compressor_10834_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_0_Torque_Compressor_10834_10561_10897_phys;
                if (Rte_TX_Inst_0_Torque_Compressor_10834_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((uint16*)&Com_TX_Inst_0_Torque_Compressor_10834_10561_10897_sgn_val) = (uint16)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.01), (double)0, (double)4095);
                    Rte_TX_Inst_0_Torque_Compressor_10834_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_0_EPower_Compressor_10835_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_0_EPower_Compressor_10835_10561_10897_phys;
                if (Rte_TX_Inst_0_EPower_Compressor_10835_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((uint16*)&Com_TX_Inst_0_EPower_Compressor_10835_10561_10897_sgn_val) = (uint16)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.1), (double)0, (double)32767);
                    Rte_TX_Inst_0_EPower_Compressor_10835_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_0_AngVel_Compressor_10836_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_0_AngVel_Compressor_10836_10561_10897_phys;
                if (Rte_TX_Inst_0_AngVel_Compressor_10836_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((uint16*)&Com_TX_Inst_0_AngVel_Compressor_10836_10561_10897_sgn_val) = (uint16)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.1), (double)0, (double)4095);
                    Rte_TX_Inst_0_AngVel_Compressor_10836_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_4_T_battery4_10816_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_4_T_battery4_10816_10561_10897_phys;
                if (Rte_TX_Inst_4_T_battery4_10816_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((uint16*)&Com_TX_Inst_4_T_battery4_10816_10561_10897_sgn_val) = (uint16)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.01), (double)0, (double)4095);
                    Rte_TX_Inst_4_T_battery4_10816_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_4_T_battery3_10817_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_4_T_battery3_10817_10561_10897_phys;
                if (Rte_TX_Inst_4_T_battery3_10817_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((uint16*)&Com_TX_Inst_4_T_battery3_10817_10561_10897_sgn_val) = (uint16)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.01), (double)0, (double)4095);
                    Rte_TX_Inst_4_T_battery3_10817_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_4_T_battery2_10818_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_4_T_battery2_10818_10561_10897_phys;
                if (Rte_TX_Inst_4_T_battery2_10818_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((uint16*)&Com_TX_Inst_4_T_battery2_10818_10561_10897_sgn_val) = (uint16)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.01), (double)0, (double)4095);
                    Rte_TX_Inst_4_T_battery2_10818_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_4_T_battery1_10819_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_4_T_battery1_10819_10561_10897_phys;
                if (Rte_TX_Inst_4_T_battery1_10819_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((uint16*)&Com_TX_Inst_4_T_battery1_10819_10561_10897_sgn_val) = (uint16)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.01), (double)0, (double)4095);
                    Rte_TX_Inst_4_T_battery1_10819_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_5_T_motor_10812_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_5_T_motor_10812_10561_10897_phys;
                if (Rte_TX_Inst_5_T_motor_10812_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((uint16*)&Com_TX_Inst_5_T_motor_10812_10561_10897_sgn_val) = (uint16)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.01), (double)0, (double)4095);
                    Rte_TX_Inst_5_T_motor_10812_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_5_T_inverter_10813_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_5_T_inverter_10813_10561_10897_phys;
                if (Rte_TX_Inst_5_T_inverter_10813_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((uint16*)&Com_TX_Inst_5_T_inverter_10813_10561_10897_sgn_val) = (uint16)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.01), (double)0, (double)4095);
                    Rte_TX_Inst_5_T_inverter_10813_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_5_T_coolant_inverter_out_10814_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_5_T_coolant_inverter_out_10814_10561_10897_phys;
                if (Rte_TX_Inst_5_T_coolant_inverter_out_10814_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((uint16*)&Com_TX_Inst_5_T_coolant_inverter_out_10814_10561_10897_sgn_val) = (uint16)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.01), (double)0, (double)4095);
                    Rte_TX_Inst_5_T_coolant_inverter_out_10814_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_5_T_coolant_battery_in_10815_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_5_T_coolant_battery_in_10815_10561_10897_phys;
                if (Rte_TX_Inst_5_T_coolant_battery_in_10815_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((uint16*)&Com_TX_Inst_5_T_coolant_battery_in_10815_10561_10897_sgn_val) = (uint16)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.01), (double)0, (double)4095);
                    Rte_TX_Inst_5_T_coolant_battery_in_10815_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_6_PJoule_battery_10808_10561_10897 :
             {
                uint16 tempVar = Rte_TX_Inst_6_PJoule_battery_10808_10561_10897_phys;
                if (Rte_TX_Inst_6_PJoule_battery_10808_10561_10897_phys_last != tempVar || always) {
                    uint16 tempVarSat = tempVar;
                    *((uint16*)&Com_TX_Inst_6_PJoule_battery_10808_10561_10897_sgn_val) = (uint16)ClampUnsigned(*((uint16*)(void*) &tempVarSat), 0, 32767);
                    Rte_TX_Inst_6_PJoule_battery_10808_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_6_p_cond_10809_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_6_p_cond_10809_10561_10897_phys;
                if (Rte_TX_Inst_6_p_cond_10809_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((uint8*)&Com_TX_Inst_6_p_cond_10809_10561_10897_sgn_val) = (uint8)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.01), (double)0, (double)UCHAR_MAX);
                    Rte_TX_Inst_6_p_cond_10809_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_6_p_chiller_10810_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_6_p_chiller_10810_10561_10897_phys;
                if (Rte_TX_Inst_6_p_chiller_10810_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((uint8*)&Com_TX_Inst_6_p_chiller_10810_10561_10897_sgn_val) = (uint8)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.01), (double)0, (double)UCHAR_MAX);
                    Rte_TX_Inst_6_p_chiller_10810_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
        case Rte_X_Inst_6_i_battery_10811_10561_10897 :
             {
                float64 tempVar = Rte_TX_Inst_6_i_battery_10811_10561_10897_phys;
                if (Rte_TX_Inst_6_i_battery_10811_10561_10897_phys_last != tempVar || always) {
                    float64 tempVarSat = tempVar;
                    *((sint16*)&Com_TX_Inst_6_i_battery_10811_10561_10897_sgn_val) = (sint16)ClampFloat(Scale_Linear_From_float64((void*) &tempVarSat, 0, 1, 0.1), (double)-2048, (double)2047);
                    Rte_TX_Inst_6_i_battery_10811_10561_10897_phys_last = tempVar;
                    return TRUE;
                }
             }
             break;
    }

    return FALSE;
}

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_WriteSignal
 *** 
 *** DESCRIPTION:
 ***     Updates the signal object identified by SignalId with the signal referenced by the
 ***     SignalDataPtr.
 *** 
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be sent.
 ***     const void *      SignalDataPtr  Reference to the signal data to store the received data in.
 *** 
 *** RETURNS:
 ***     uint8    The status code of the function call.
\**************************************************************************************************/
uint8 Rte_WriteSignal(Rte_SignalIdType SignalId, const void * SignalDataPtr)
{
    POSSIBLE_UNREFERENCED_PARAMETER(SignalId);
    POSSIBLE_UNREFERENCED_PARAMETER(SignalDataPtr);

    return RTE_NO_SUCH_SIGNAL;

}

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_ReadSignal
 *** 
 *** DESCRIPTION:
 ***     The function copies the content of the associated shadow buffer to the given memory location
 ***     and performs signal conversion.
 *** 
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be read.
 ***     void *            SignalDataPtr  Reference to the signal data to store the received data in.
 *** 
 *** RETURNS:
 ***     uint8    The status code of the function call.
\**************************************************************************************************/
uint8 Rte_ReadSignal(Rte_SignalIdType SignalId, void * SignalDataPtr)
{
    POSSIBLE_UNREFERENCED_PARAMETER(SignalId);
    POSSIBLE_UNREFERENCED_PARAMETER(SignalDataPtr);


    return RTE_NO_SUCH_SIGNAL;
}

